/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_compose_endpoint_addr.c,v 1.13 2005/06/29 00:23:16 eugene Exp $";

#include <string.h>
#include "mx_auto_config.h"

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "tcp.h"
#include "internal.h"
#include "mx_byteswap.h"

mx_return_t
mx_connect(struct mx_endpoint *endpoint, uint64_t nic_id, 
	   uint32_t endpoint_id, uint32_t connect_key, 
	   uint32_t timeout,
	   mx_endpoint_addr_t *addr)
{
  struct mx_lib_address *liba;

  liba = (struct mx_lib_address *) addr;
  liba->ipaddr_n = htonl((uint32_t)nic_id);
  liba->ipport_n = htons((uint16_t)endpoint_id + ENDPOINT_BASE);
  liba->filter_n = htonl(connect_key);
  liba->pad0 = 0;
  liba->pad1 = 0;
  return MX_SUCCESS;
}
